/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{
  public class CMainForm : Form
  {  
    public CMainForm() 
    {
      OpenFileDialog of   = new OpenFileDialog();
      of.InitialDirectory = 
        Environment.GetFolderPath( Environment.SpecialFolder.ProgramFiles );
      of.Title            = "Wybierz plik do otwarcia...";
      of.Filter           = "Moje pliki (*.xyz)|*.xyz|"+
                            "Wszystkie pliki (*.*)|*.*";
      of.Multiselect      = true;

      DialogResult res = of.ShowDialog();
      if ( res == DialogResult.OK )
        foreach ( string fileName in of.FileNames )
          MessageBox.Show( "Wybrano plik " + fileName );
    }

    public static void Main()
    {    
      Application.Run( new CMainForm() );
    }
  }
}
